<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * SiteController
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class ReportController extends Controller
{
	public function init()
	{
		 
		if(Yii::app()->user->getId()=="")
		{  
			Yii::app()->user->setReturnUrl(Yii::app()->request->requestUri );
			$this->redirect(Yii::app()->createUrl("user/signin"));
		} 
	}
    public function actionIndex($slug=null,$back=null)
    {
	 
	 $model = new ReportListing();
	 if(Yii::app()->request->isPostRequest)
	 {
		$model->attributes = $_POST;
		$model->user_id =  Yii::app()->user->getId(); 
		if($model->save())
		{
			
			//Send Email to Admin
			    Yii::import('webroot.apps.extensions.YiiMailer.YiiMailer');
				$emailTemplate =  CustomerEmailTemplate::model()->findByName("Report listing");
			    
			    if($emailTemplate)
			    {
						$emailTemplate = $emailTemplate->content;
				}
				else
				{
					    $emailTemplate = $options->get('system.email_templates.common');
				}
				 
                $emailBody = "";
                $emailTemplate = str_replace('{user}',@$model->user->first_name." ". @$model->user->last_name, $emailTemplate);
                $emailTemplate = str_replace('{type}',@$model->type, $emailTemplate);
                $emailTemplate = str_replace('{details}',@$model->details, $emailTemplate);
                $emailTemplate = str_replace('{date}',date('d-m-Y'), $emailTemplate);
				$logo =  '<a href="'.Yii::app()->createUrl("").'" alt=""><img src="'. Yii::app()->params['uploadDir']."/logo/" .Yii::app()->options->get('system.common.logo').'" style="width:134px;height:56px;"></a> ';
				$emailTemplate = str_replace('{logo}',$logo, $emailTemplate);
                 
				$params = array(
				'to'            =>   Yii::app()->options->get('system.common.admin_email'),
				'fromName'      =>   Yii::app()->options->get('system.common.site_name'),
				'subject'       =>	 Yii::app()->name .' Spam reporting  ' ,
				'body'          =>   $emailTemplate,
				);
				
				
				$mapping = DeliveryServer::getTypesMapping();
				$server = DeliveryServer::model($mapping['smtp'])->findByPk((int)4);
			
				$server->sendEmail($params);
				
				Yii::app()->user->setFlash('success',"Successfully reported \"".$model->type."\"");
				$this->redirect(Yii::app()->request->baseUrl.base64_decode($back));
			
			
			
			
			
			
			
			exit;
		}
		else
		{
			Yii::app()->user->setFlash("error",1);
		}
	 }
	 $ad = PlaceAnAd::model()->AdFromSlug($slug);
	 if(empty($ad))
	 {
		throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
	 }
	 $this->layout =   Yii::app()->LayoutClass->layoutpath("fullwidth"); 
     
	 $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', '{name} :: home', array('{name}' => Yii::app()->name )), 
                    'pageMetaDescription'   => Yii::app()->params['description'],
                ));
                
	 $this->render( Yii::app()->LayoutClass->viewpath("index"),compact("model","ad","back"));
    }
    
  
 

}
